/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.xml.XML;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.w3c.dom.Node;

final class JsonNode {
    private final transient XML xml;

    JsonNode(XML src) {
        this.xml = src;
    }

    public JsonObject json() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (XML child : this.xml.nodes("* ")) {
            Node node = child.node();
            if (child.nodes("*").isEmpty()) {
                builder.add(node.getNodeName(), node.getTextContent());
                continue;
            }
            if (!child.xpath("//@array").isEmpty() && "true".equals(child.xpath("//@array").get(0))) {
                JsonArrayBuilder bld = Json.createArrayBuilder();
                for (XML item : child.nodes("*")) {
                    bld.add(item.node().getTextContent());
                }
                builder.add(node.getNodeName(), bld.build());
                continue;
            }
            builder.add(node.getNodeName(), new JsonNode(child).json());
        }
        return builder.build();
    }
}

