/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Blob;
import com.jcabi.github.Blobs;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkBlob;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import org.apache.commons.lang3.RandomStringUtils;
import org.xembly.Directives;

@Immutable
final class MkBlobs
implements Blobs {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    public MkBlobs(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']/git", this.coords)).addIf("blobs"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Blob get(String sha) {
        return new MkBlob(this.storage, sha, this.coords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob create(String content, String encoding) throws IOException {
        this.storage.lock();
        String sha = MkBlobs.fakeSha();
        try {
            this.storage.apply(new Directives().xpath(this.xpath()).add("blob").add("sha").set(sha).up().add("url").set("http://localhost/1").up().attr("content", content).attr("encoding", encoding));
        }
        finally {
            this.storage.unlock();
        }
        return this.get(sha);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/git/blobs", this.coords);
    }

    private static String fakeSha() {
        return RandomStringUtils.random(40, "0123456789abcdef");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkBlobs)) {
            return false;
        }
        MkBlobs other = (MkBlobs)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

