/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Check;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Pull;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;

@Immutable
@Loggable(value=1)
public final class MkCheck
implements Check {
    private final transient MkStorage storage;
    private final transient Coordinates coordinates;
    private final transient Pull pull;
    private final transient int identifier;

    public MkCheck(MkStorage stg, Coordinates coord, Pull pll, int number) {
        this.storage = stg;
        this.coordinates = coord;
        this.pull = pll;
        this.identifier = number;
    }

    @Override
    public boolean successful() throws IOException {
        XML node = this.storage.xml().nodes(this.xpath()).get(0);
        Check.Status status = Check.Status.fromString(node.xpath("@status").get(0));
        Check.Conclusion conclusion = Check.Conclusion.fromString(node.xpath("@conclusion").get(0));
        return status == Check.Status.COMPLETED && conclusion == Check.Conclusion.SUCCESS;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']/checks/check[@id='%d']", this.coordinates, this.pull.number(), this.identifier);
    }

    public String toString() {
        return "MkCheck(storage=" + this.storage + ", coordinates=" + this.coordinates + ", pull=" + this.pull + ", identifier=" + this.identifier + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkCheck)) {
            return false;
        }
        MkCheck other = (MkCheck)o;
        if (this.identifier != other.identifier) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        Coordinates this$coordinates = this.coordinates;
        Coordinates other$coordinates = other.coordinates;
        if (this$coordinates == null ? other$coordinates != null : !this$coordinates.equals(other$coordinates)) {
            return false;
        }
        Pull this$pull = this.pull;
        Pull other$pull = other.pull;
        return !(this$pull == null ? other$pull != null : !this$pull.equals(other$pull));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.identifier;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        Coordinates $coordinates = this.coordinates;
        result = result * 59 + ($coordinates == null ? 43 : $coordinates.hashCode());
        Pull $pull = this.pull;
        result = result * 59 + ($pull == null ? 43 : $pull.hashCode());
        return result;
    }
}

