/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comment;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Issue;
import com.jcabi.github.Reaction;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkIssue;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import java.util.Collection;
import javax.json.JsonObject;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkComment
implements Comment {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates repo;
    private final transient int ticket;
    private final transient int num;

    MkComment(MkStorage stg, String login, Coordinates rep, int issue, int number) {
        this.storage = stg;
        this.self = login;
        this.repo = rep;
        this.ticket = issue;
        this.num = number;
    }

    @Override
    public Issue issue() {
        return new MkIssue(this.storage, this.self, this.repo, this.ticket);
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public void remove() throws IOException {
        this.storage.apply(new Directives().xpath(this.xpath()).strict(1).remove());
    }

    @Override
    public int compareTo(Comment comment) {
        return this.number() - comment.number();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode(this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void react(Reaction reaction) {
        throw new UnsupportedOperationException("react() not implemented");
    }

    public Collection<Reaction> reactions() {
        throw new UnsupportedOperationException("reactions() not implemented");
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issues/issue[number='%d']/comments/comment[number='%d']", this.repo, this.ticket, this.num);
    }

    public String toString() {
        return "MkComment(storage=" + this.storage + ", self=" + this.self + ", repo=" + this.repo + ", ticket=" + this.ticket + ", num=" + this.num + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkComment)) {
            return false;
        }
        MkComment other = (MkComment)o;
        if (this.ticket != other.ticket) {
            return false;
        }
        if (this.num != other.num) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$repo = this.repo;
        Coordinates other$repo = other.repo;
        return !(this$repo == null ? other$repo != null : !this$repo.equals(other$repo));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.ticket;
        result = result * 59 + this.num;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        return result;
    }
}

