/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comment;
import com.jcabi.github.Comments;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Issue;
import com.jcabi.github.mock.MkComment;
import com.jcabi.github.mock.MkIssue;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.util.Date;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkComments
implements Comments {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates repo;
    private final transient int ticket;

    MkComments(MkStorage stg, String login, Coordinates rep, int issue) throws IOException {
        this.storage = stg;
        this.self = login;
        this.repo = rep;
        this.ticket = issue;
        this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']/issues/issue[number='%d']", this.repo, this.ticket)).addIf("comments"));
    }

    @Override
    public Issue issue() {
        return new MkIssue(this.storage, this.self, this.repo, this.ticket);
    }

    @Override
    public Comment get(int number) {
        return new MkComment(this.storage, this.self, this.repo, this.ticket, number);
    }

    @Override
    public Iterable<Comment> iterate(Date since) {
        return new MkIterable<Comment>(this.storage, String.format("%s/comment", this.xpath()), xml -> this.get(Integer.parseInt(xml.xpath("number/text()").get(0))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment post(String text) throws IOException {
        int number;
        this.storage.lock();
        try {
            String timestamp = new Github.Time().toString();
            number = 1 + this.storage.xml().nodes("//comment/number").size();
            this.storage.apply(new Directives().xpath(this.xpath()).add("comment").add("number").set(Integer.toString(number)).up().add("url").set(String.format("https://api.jcabi-github.invalid/repos/%s/%s/issues/comments/%d", this.repo.user(), this.repo.repo(), number)).up().add("body").set(text).up().add("user").add("login").set(this.self).up().up().add("created_at").set(timestamp).up().add("updated_at").set(timestamp));
        }
        finally {
            this.storage.unlock();
        }
        Logger.info(this, "comment #%d posted to issue #%d by %s: %[text]s", number, this.issue().number(), this.self, text);
        return this.get(number);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issues/issue[number='%d']/comments", this.repo, this.ticket);
    }

    public String toString() {
        return "MkComments(storage=" + this.storage + ", self=" + this.self + ", repo=" + this.repo + ", ticket=" + this.ticket + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkComments)) {
            return false;
        }
        MkComments other = (MkComments)o;
        if (this.ticket != other.ticket) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$repo = this.repo;
        Coordinates other$repo = other.repo;
        return !(this$repo == null ? other$repo != null : !this$repo.equals(other$repo));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.ticket;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        return result;
    }
}

