/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Content;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.json.JsonObject;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.builder.CompareToBuilder;

@Immutable
@Loggable(value=1)
final class MkContent
implements Content {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient String location;
    private final transient String branch;

    public MkContent(MkStorage stg, String login, Coordinates rep, String path, String ref) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.location = path;
        this.branch = ref;
    }

    @Override
    public int compareTo(Content cont) {
        return new CompareToBuilder().append(this.path(), cont.path()).append(this.repo().coordinates(), cont.repo().coordinates()).build();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode(this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public String path() {
        return this.location;
    }

    @Override
    public InputStream raw() throws IOException {
        return new ByteArrayInputStream(DatatypeConverter.parseBase64Binary(this.storage.xml().xpath(String.format("%s/content/text()", this.xpath())).get(0)));
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/contents/content[path='%s' and @ref='%s']", this.coords, this.location, this.branch);
    }

    public String toString() {
        return "MkContent(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", location=" + this.location + ", branch=" + this.branch + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkContent)) {
            return false;
        }
        MkContent other = (MkContent)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        if (this$coords == null ? other$coords != null : !this$coords.equals(other$coords)) {
            return false;
        }
        String this$location = this.location;
        String other$location = other.location;
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$branch = this.branch;
        String other$branch = other.branch;
        return !(this$branch == null ? other$branch != null : !this$branch.equals(other$branch));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        String $location = this.location;
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $branch = this.branch;
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        return result;
    }
}

