/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Fork;
import com.jcabi.github.Forks;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkFork;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.log.Logger;
import java.io.IOException;
import org.xembly.Directives;

@Immutable
final class MkForks
implements Forks {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    public MkForks(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf("forks"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    public Fork get(int forkid) {
        return new MkFork(this.storage, forkid, this.coords);
    }

    @Override
    public Iterable<Fork> iterate(String sort) {
        return new MkIterable<Fork>(this.storage, String.format("%s/fork", this.xpath()), xml -> this.get(Integer.parseInt(xml.xpath("id/text()").get(0))));
    }

    @Override
    public Fork create(String org) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(String.format("%s/fork/id/text()", this.xpath())).size();
            this.storage.apply(new Directives().xpath(this.xpath()).add("fork").add("id").set(Integer.toString(number)).up().attr("organization", org));
        }
        finally {
            this.storage.unlock();
        }
        Logger.info(this, "fork %s created inside %s by %s", this.coords, org, this.self);
        return this.get(number);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/forks", this.coords);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkForks)) {
            return false;
        }
        MkForks other = (MkForks)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

