/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Event;
import com.jcabi.github.Hook;
import com.jcabi.github.Hooks;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkHook;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import java.util.Map;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkHooks
implements Hooks {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    public MkHooks(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf("hooks"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Iterable<Hook> iterate() {
        return new MkIterable<Hook>(this.storage, String.format("%s/hook", this.xpath()), xml -> this.get(Integer.parseInt(xml.xpath("id/text()").get(0))));
    }

    @Override
    public Hook get(int number) {
        return new MkHook(this.storage, this.self, this.coords, number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hook create(String name, Map<String, String> config, Iterable<Event> events, boolean active) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(String.format("%s/hook/id/text()", this.xpath())).size();
            Directives dirs = new Directives().xpath(this.xpath()).add("hook").add("id").set(String.valueOf(number)).up().add("name").set(name).up().add("active").set(Boolean.toString(active)).up().add("events");
            for (Event event : events) {
                dirs.add("event").set(event.toString()).up();
            }
            dirs.up().add("config");
            for (Map.Entry entry : config.entrySet()) {
                dirs.add(entry.getKey()).set(entry.getValue()).up();
            }
            this.storage.apply(dirs);
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    @Override
    public void remove(int number) throws IOException {
        this.storage.apply(new Directives().xpath(String.format("%s/hook[id='%d']", this.xpath(), number)).remove());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/hooks", this.coords);
    }

    public String toString() {
        return "MkHooks(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkHooks)) {
            return false;
        }
        MkHooks other = (MkHooks)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

