/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Issue;
import com.jcabi.github.IssueLabels;
import com.jcabi.github.Label;
import com.jcabi.github.mock.MkIssue;
import com.jcabi.github.mock.MkIssueEvents;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkLabel;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkIssueLabels
implements IssueLabels {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates repo;
    private final transient int ticket;

    MkIssueLabels(MkStorage stg, String login, Coordinates rep, int issue) throws IOException {
        this.storage = stg;
        this.self = login;
        this.repo = rep;
        this.ticket = issue;
        this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']/issues/issue[number='%d']", rep, this.ticket)).addIf("labels"));
    }

    @Override
    public Issue issue() {
        return new MkIssue(this.storage, this.self, this.repo, this.ticket);
    }

    @Override
    public void add(Iterable<String> labels) throws IOException {
        Collection<String> existing = this.labels();
        HashSet<String> added = new HashSet<String>();
        Directives dirs = new Directives().xpath(this.xpath());
        for (String label : labels) {
            dirs.add("label").set(label).up();
            if (existing.contains(label)) continue;
            added.add(label);
        }
        this.storage.apply(dirs);
        if (!added.isEmpty()) {
            MkIssueEvents events = new MkIssueEvents(this.storage, this.self, this.repo);
            for (String label : added) {
                events.create("labeled", this.ticket, this.self, Optional.of(label));
            }
        }
    }

    @Override
    public void replace(Iterable<String> labels) throws IOException {
        this.clear();
        this.add(labels);
    }

    @Override
    public Iterable<Label> iterate() {
        return new MkIterable<Label>(this.storage, String.format("%s/*", this.xpath()), xml -> new MkLabel(this.storage, this.self, this.repo, xml.xpath("./text()").get(0)));
    }

    @Override
    public void remove(String name) throws IOException {
        if (this.labels().contains(name)) {
            this.storage.apply(new Directives().xpath(String.format("%s/label[.='%s']", this.xpath(), name)).remove());
            new MkIssueEvents(this.storage, this.self, this.repo).create("unlabeled", this.ticket, this.self, Optional.of(name));
        }
    }

    @Override
    public void clear() throws IOException {
        for (String label : this.labels()) {
            this.remove(label);
        }
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issues/issue[number='%d']/labels", this.repo, this.ticket);
    }

    private Collection<String> labels() {
        HashSet<String> labels = new HashSet<String>();
        for (Label label : this.iterate()) {
            labels.add(label.name());
        }
        return labels;
    }

    public String toString() {
        return "MkIssueLabels(storage=" + this.storage + ", self=" + this.self + ", repo=" + this.repo + ", ticket=" + this.ticket + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkIssueLabels)) {
            return false;
        }
        MkIssueLabels other = (MkIssueLabels)o;
        if (this.ticket != other.ticket) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        Coordinates this$repo = this.repo;
        Coordinates other$repo = other.repo;
        return !(this$repo == null ? other$repo != null : !this$repo.equals(other$repo));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.ticket;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        Coordinates $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        return result;
    }
}

