/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Label;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class MkLabel
implements Label {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates owner;
    private final transient String label;

    MkLabel(MkStorage stg, String login, Coordinates rep, String name) {
        this.storage = stg;
        this.self = login;
        this.owner = rep;
        this.label = name;
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.owner);
    }

    @Override
    public String name() {
        return this.label;
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode(this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public int compareTo(Label lbl) {
        return this.label.compareTo(lbl.name());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/labels/label[name='%s']", this.owner, this.label);
    }

    public String toString() {
        return "MkLabel(storage=" + this.storage + ", self=" + this.self + ", owner=" + this.owner + ", label=" + this.label + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkLabel)) {
            return false;
        }
        MkLabel other = (MkLabel)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$owner = this.owner;
        Coordinates other$owner = other.owner;
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$label = this.label;
        String other$label = other.label;
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $label = this.label;
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }
}

