/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Milestone;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
final class MkMilestone
implements Milestone {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int code;

    MkMilestone(MkStorage strg, String login, Coordinates crds, int num) {
        this.self = login;
        this.coords = crds;
        this.storage = strg;
        this.code = num;
    }

    public boolean equals(Object obj) {
        return obj instanceof Milestone && this.code == ((Milestone)Milestone.class.cast(obj)).number();
    }

    public int hashCode() {
        return this.code;
    }

    @Override
    public int compareTo(Milestone milestone) {
        assert (this.self != null);
        assert (this.coords != null);
        assert (this.storage != null);
        assert (this.code != -1);
        int result = this.coords.compareTo(milestone.repo().coordinates());
        if (result == 0) {
            result = Integer.compare(this.code, milestone.number());
        }
        return result;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode(this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public int number() {
        return this.code;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/milestones[number='%d']", this.coords, this.code);
    }
}

