/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Organization;
import com.jcabi.github.Organizations;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkOrganization;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkOrganizations
implements Organizations {
    private final transient MkStorage storage;

    MkOrganizations(MkStorage stg) throws IOException {
        this.storage = stg;
        this.storage.apply(new Directives().xpath("/github").addIf("orgs"));
    }

    @Override
    public Organization get(String login) {
        try {
            this.storage.apply(new Directives().xpath(String.format("/github/orgs[not(org[login='%s'])]", login)).add("org").add("login").set(login).up().add("members").up());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return new MkOrganization(this.storage, login);
    }

    @Override
    public Iterable<Organization> iterate() {
        return new MkIterable<Organization>(this.storage, String.format("%s/org", this.xpath()), xml -> this.get(xml.xpath("login/text()").get(0)));
    }

    private String xpath() {
        return "/github/orgs";
    }

    public String toString() {
        return "MkOrganizations(storage=" + this.storage + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkOrganizations)) {
            return false;
        }
        MkOrganizations other = (MkOrganizations)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        return !(this$storage == null ? other$storage != null : !this$storage.equals(other$storage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        return result;
    }
}

