/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.PublicKey;
import com.jcabi.github.PublicKeys;
import com.jcabi.github.User;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkPublicKey;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import java.io.IOException;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkPublicKeys
implements PublicKeys {
    private final transient MkStorage storage;
    private final transient String self;

    public MkPublicKeys(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.self = login;
        this.storage.apply(new Directives().xpath(this.userXpath()).addIf("keys"));
    }

    @Override
    public User user() {
        return new MkUser(this.storage, this.self);
    }

    @Override
    public Iterable<PublicKey> iterate() {
        return new MkIterable<PublicKey>(this.storage, String.format("%s/key", this.xpath()), xml -> this.get(Integer.parseInt(xml.xpath("id/text()").get(0))));
    }

    @Override
    public PublicKey get(int number) {
        return new MkPublicKey(this.storage, this.self, number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicKey create(String title, String key) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(String.format("%s/key/id/text()", this.xpath())).size();
            this.storage.apply(new Directives().xpath(this.xpath()).add("key").add("id").set(String.valueOf(number)).up().add("title").set(title).up().add("key").set(key));
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    @Override
    public void remove(int number) throws IOException {
        this.storage.apply(new Directives().xpath(String.format("%s/key[id='%d']", this.xpath(), number)).remove());
    }

    private String userXpath() {
        return String.format("/github/users/user[login='%s']", this.self);
    }

    private String xpath() {
        return String.format("%s/keys", this.userXpath());
    }

    public String toString() {
        return "MkPublicKeys(storage=" + this.storage + ", self=" + this.self + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPublicKeys)) {
            return false;
        }
        MkPublicKeys other = (MkPublicKeys)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

