/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Checks;
import com.jcabi.github.Commit;
import com.jcabi.github.Coordinates;
import com.jcabi.github.MergeState;
import com.jcabi.github.Pull;
import com.jcabi.github.PullComments;
import com.jcabi.github.PullRef;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkBranches;
import com.jcabi.github.mock.MkChecks;
import com.jcabi.github.mock.MkPullComments;
import com.jcabi.github.mock.MkPullRef;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

@Immutable
@Loggable(value=1)
final class MkPull
implements Pull {
    private static final String USER_BRANCH_SEP = ":";
    private static final String REF_PROP = "ref";
    private static final String LABEL_PROP = "label";
    private static final String NUMBER_PROP = "number";
    private static final String USER_PROP = "user";
    private static final String HEAD_PROP = "head";
    private static final String BASE_PROP = "base";
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int num;

    MkPull(MkStorage stg, String login, Coordinates rep, int number) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.num = number;
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public PullRef base() throws IOException {
        return new MkPullRef(this.storage, new MkBranches(this.storage, this.self, this.coords).get(this.storage.xml().xpath(String.format("%s/base/text()", this.xpath())).get(0)));
    }

    @Override
    public PullRef head() throws IOException {
        String userbranch = this.storage.xml().xpath(String.format("%s/head/text()", this.xpath())).get(0);
        String[] parts = userbranch.split(USER_BRANCH_SEP, 2);
        if (parts.length != 2) {
            throw new IllegalStateException("Invalid MkPull head");
        }
        String user = parts[0];
        String branch = parts[1];
        return new MkPullRef(this.storage, new MkBranches(this.storage, this.self, new Coordinates.Simple(user, this.coords.repo())).get(branch));
    }

    @Override
    public Iterable<Commit> commits() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<JsonObject> files() {
        return Collections.emptyList();
    }

    @Override
    public void merge(String msg) {
    }

    @Override
    public MergeState merge(String msg, String sha) {
        throw new UnsupportedOperationException("Merge not supported");
    }

    @Override
    public PullComments comments() throws IOException {
        return new MkPullComments(this.storage, this.self, this.coords, this);
    }

    @Override
    public Checks checks() {
        return new MkChecks(this.storage, this.coords, this);
    }

    @Override
    public int compareTo(Pull pull) {
        return this.number() - pull.number();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public JsonObject json() throws IOException {
        XML xml = this.storage.xml().nodes(this.xpath()).get(0);
        String branch = xml.xpath("base/text()").get(0);
        String head = xml.xpath("head/text()").get(0);
        String[] parts = head.split(USER_BRANCH_SEP, 2);
        JsonObject obj = new JsonNode(xml).json();
        JsonObjectBuilder json = Json.createObjectBuilder();
        for (Map.Entry val : obj.entrySet()) {
            if (NUMBER_PROP.equals(val.getKey())) {
                json.add(NUMBER_PROP, Integer.parseInt(xml.xpath("number/text()").get(0)));
                continue;
            }
            if (USER_PROP.equals(val.getKey())) {
                json.add(USER_PROP, Json.createObjectBuilder().add("login", xml.xpath("user/login/text()").get(0)).build());
                continue;
            }
            if (HEAD_PROP.equals(val.getKey())) {
                json.add(HEAD_PROP, Json.createObjectBuilder().add(REF_PROP, parts[1]).add(LABEL_PROP, head).build());
                continue;
            }
            if (BASE_PROP.equals(val.getKey())) {
                json.add(BASE_PROP, Json.createObjectBuilder().add(REF_PROP, branch).add(LABEL_PROP, String.format("%s:%s", this.coords.user(), branch)).build());
                continue;
            }
            json.add((String)val.getKey(), (JsonValue)val.getValue());
        }
        json.add("comments", this.storage.xml().nodes(this.comment()).size());
        return json.build();
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']", this.coords, this.num);
    }

    private String comment() {
        return String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']/comments/comment", this.coords, this.num);
    }

    public String toString() {
        return "MkPull(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", num=" + this.num + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPull)) {
            return false;
        }
        MkPull other = (MkPull)o;
        if (this.num != other.num) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.num;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

