/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Branch;
import com.jcabi.github.PullRef;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class MkPullRef
implements PullRef {
    private final transient MkStorage storage;
    private final transient Branch branch;

    MkPullRef(MkStorage stg, Branch brnch) {
        this.storage = stg;
        this.branch = brnch;
    }

    @Override
    public Repo repo() {
        return this.branch.repo();
    }

    @Override
    public String ref() {
        return this.branch.name();
    }

    @Override
    public String sha() {
        return this.branch.commit().sha();
    }

    @Override
    public JsonObject json() throws IOException {
        String user = this.repo().coordinates().user();
        return Json.createObjectBuilder().add("ref", this.ref()).add("sha", this.sha()).add("label", String.format("%s:%s", user, this.ref())).add("user", new MkUser(this.storage, user).json()).add("repo", this.repo().json()).build();
    }

    public String toString() {
        return "MkPullRef(storage=" + this.storage + ", branch=" + this.branch + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPullRef)) {
            return false;
        }
        MkPullRef other = (MkPullRef)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        Branch this$branch = this.branch;
        Branch other$branch = other.branch;
        return !(this$branch == null ? other$branch != null : !this$branch.equals(other$branch));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        Branch $branch = this.branch;
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        return result;
    }
}

