/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Issue;
import com.jcabi.github.Pull;
import com.jcabi.github.Pulls;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkPull;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import java.util.Map;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkPulls
implements Pulls {
    private static final String USER_BRANCH_SEP = ":";
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkPulls(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf("pulls"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Pull get(int number) {
        return new MkPull(this.storage, this.self, this.coords, number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pull create(String title, String head, String base) throws IOException {
        int number;
        if (head.isEmpty()) {
            throw new IllegalArgumentException("head cannot be empty!");
        }
        if (base.isEmpty()) {
            throw new IllegalArgumentException("base cannot be empty!");
        }
        String canonical = head.contains(USER_BRANCH_SEP) ? head : String.format("%s%s%s", this.coords.user(), USER_BRANCH_SEP, head);
        this.storage.lock();
        try {
            Issue issue = this.repo().issues().create(title, "some body");
            number = issue.number();
            this.storage.apply(new Directives().xpath(this.xpath()).add("pull").add("number").set(Integer.toString(number)).up().add("head").set(canonical).up().add("base").set(base).up().add("checks").up().add("user").add("login").set(this.self).up());
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    @Override
    public Iterable<Pull> iterate(Map<String, String> params) {
        return new MkIterable<Pull>(this.storage, String.format("%s/pull", this.xpath()), xml -> this.get(Integer.parseInt(xml.xpath("number/text()").get(0))));
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/pulls", this.coords);
    }

    public String toString() {
        return "MkPulls(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkPulls)) {
            return false;
        }
        MkPulls other = (MkPulls)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

