/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Reference;
import com.jcabi.github.References;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkReference;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkReferences
implements References {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkReferences(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']/git", this.coords)).addIf("refs"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Reference create(String ref, String sha) throws IOException {
        this.storage.apply(new Directives().xpath(this.xpath()).add("reference").add("ref").set(ref).up().add("sha").set(sha).up());
        return this.get(ref);
    }

    @Override
    public Reference get(String identifier) {
        return new MkReference(this.storage, this.self, this.coords, identifier);
    }

    @Override
    public Iterable<Reference> iterate() {
        return new MkIterable<Reference>(this.storage, String.format("%s/reference", this.xpath()), xml -> this.get(xml.xpath("ref/text()").get(0)));
    }

    @Override
    public Iterable<Reference> iterate(String subnamespace) {
        return new MkIterable<Reference>(this.storage, String.format("%s/reference/ref[starts-with(., 'refs/%s')]", this.xpath(), subnamespace), xml -> this.get(xml.xpath("text()").get(0)));
    }

    @Override
    public Iterable<Reference> tags() {
        return this.iterate("tags");
    }

    @Override
    public Iterable<Reference> heads() {
        return this.iterate("heads");
    }

    @Override
    public void remove(String identifier) throws IOException {
        this.storage.apply(new Directives().xpath(String.format("%s/reference[ref='%s']", this.xpath(), identifier)).remove());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/git/refs", this.coords);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkReferences)) {
            return false;
        }
        MkReferences other = (MkReferences)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

