/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Repo;
import com.jcabi.github.Repos;
import com.jcabi.github.mock.MkGithub;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.log.Logger;
import java.io.IOException;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkRepos
implements Repos {
    private final transient MkStorage storage;
    private final transient String self;

    MkRepos(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.self = login;
        this.storage.apply(new Directives().xpath("/github").addIf("repos"));
    }

    @Override
    public Github github() {
        return new MkGithub(this.storage, this.self);
    }

    @Override
    public Repo create(Repos.RepoCreate settings) throws IOException {
        String owner = this.self;
        String org = settings.organization();
        if (org != null && !org.isEmpty()) {
            owner = "/orgs/".concat(org).concat("/repos");
        }
        Coordinates.Simple coords = new Coordinates.Simple(owner, settings.name());
        this.storage.apply(new Directives().xpath(this.xpath()).add("repo").attr("coords", ((Object)coords).toString()).add("name").set(settings.name()).up().add("description").set("test repository").up().add("private").set(settings.isPrivate()).up());
        Repo repo = this.get(coords);
        repo.patch(settings.json());
        Logger.info(this, "repository %s created by %s", coords, owner);
        return repo;
    }

    @Override
    public Repo get(Coordinates coords) {
        try {
            String xpath = String.format("%s/repo[@coords='%s']", this.xpath(), coords);
            if (this.storage.xml().nodes(xpath).isEmpty()) {
                throw new IllegalArgumentException(String.format("repository %s doesn't exist", coords));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return new MkRepo(this.storage, this.self, coords);
    }

    @Override
    public void remove(Coordinates coords) {
        try {
            this.storage.apply(new Directives().xpath(String.format("%s/repo[@coords='%s']", this.xpath(), coords)).remove());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Iterable<Repo> iterate(String identifier) {
        return new MkIterable<Repo>(this.storage, "/github/repos/repo", xml -> new MkRepo(this.storage, this.self, new Coordinates.Simple(xml.xpath("@coords").get(0))));
    }

    @Override
    public boolean exists(Coordinates coords) throws IOException {
        String xpath = String.format("%s/repo[@coords='%s']", this.xpath(), coords);
        return !this.storage.xml().nodes(xpath).isEmpty();
    }

    private String xpath() {
        return "/github/repos";
    }

    public String toString() {
        return "MkRepos(storage=" + this.storage + ", self=" + this.self + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkRepos)) {
            return false;
        }
        MkRepos other = (MkRepos)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

