/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.Tree;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class MkTree
implements Tree {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient String sha;

    MkTree(MkStorage strg, String login, Coordinates crds, String identifier) {
        this.storage = strg;
        this.self = login;
        this.coords = crds;
        this.sha = '\"' + identifier + '\"';
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode(this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public String sha() {
        return this.sha;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords = '%s']/git/trees/tree[sha = '%s']", this.coords, this.sha);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkTree)) {
            return false;
        }
        MkTree other = (MkTree)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        if (this$coords == null ? other$coords != null : !this$coords.equals(other$coords)) {
            return false;
        }
        String this$sha = this.sha;
        String other$sha = other.sha;
        return !(this$sha == null ? other$sha != null : !this$sha.equals(other$sha));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        String $sha = this.sha;
        result = result * 59 + ($sha == null ? 43 : $sha.hashCode());
        return result;
    }
}

