/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.Tree;
import com.jcabi.github.Trees;
import com.jcabi.github.mock.MkReferences;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkTree;
import java.io.IOException;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkTrees
implements Trees {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkTrees(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply(new Directives().xpath(String.format("/github/repos/repo[@coords='%s']/git", this.coords)).addIf("trees"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Tree create(JsonObject params) throws IOException {
        JsonArray trees = params.getJsonArray("tree");
        for (JsonValue val : trees) {
            JsonObject tree = (JsonObject)val;
            String sha = tree.getString("sha");
            Directives dirs = new Directives().xpath(this.xpath()).add("tree");
            for (Map.Entry entry : tree.entrySet()) {
                dirs.add(entry.getKey()).set(((JsonValue)entry.getValue()).toString()).up();
            }
            this.storage.apply(dirs);
            String ref = tree.containsValue("name") ? tree.getString("name") : sha;
            new MkReferences(this.storage, this.self, this.coords).create("refs/trees/" + ref, sha);
        }
        return this.get(trees.getJsonObject(0).getString("sha"));
    }

    @Override
    public Tree get(String sha) {
        return new MkTree(this.storage, this.self, this.coords, sha);
    }

    @Override
    public Tree getRec(String sha) {
        return new MkTree(this.storage, this.self, this.coords, sha);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/git/trees", this.coords);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkTrees)) {
            return false;
        }
        MkTrees other = (MkTrees)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

