/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.UserEmails;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import javax.json.JsonObject;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkUserEmails
implements UserEmails {
    private static final MkIterable.Mapping<String> MAPPING = xml -> xml.xpath("./text()").get(0);
    private final transient MkStorage storage;
    private final transient String self;

    MkUserEmails(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.self = login;
        this.storage.apply(new Directives().xpath(this.userXpath()).addIf("emails"));
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode(this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public Iterable<String> iterate() {
        return new MkIterable<String>(this.storage, String.format("%s/email", this.xpath()), MAPPING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> add(Iterable<String> emails) throws IOException {
        this.storage.lock();
        try {
            Directives directives = new Directives().xpath(this.xpath());
            for (String email : emails) {
                directives.add("email").set(email).up();
            }
            this.storage.apply(directives);
        }
        finally {
            this.storage.unlock();
        }
        return emails;
    }

    @Override
    public void remove(Iterable<String> emails) throws IOException {
        Directives directives = new Directives();
        for (String email : emails) {
            directives.xpath(String.format("%s/email[.='%s']", this.xpath(), email)).remove();
        }
        this.storage.apply(directives);
    }

    private String userXpath() {
        return String.format("/github/users/user[login='%s']", this.self);
    }

    private String xpath() {
        return String.format("%s/emails", this.userXpath());
    }

    public String toString() {
        return "MkUserEmails(storage=" + this.storage + ", self=" + this.self + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkUserEmails)) {
            return false;
        }
        MkUserEmails other = (MkUserEmails)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

