/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.safe;

import com.google.common.collect.Iterables;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comment;
import com.jcabi.github.Comments;
import com.jcabi.github.Issue;
import com.jcabi.github.mock.MkGithub;
import com.jcabi.github.safe.SfComment;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.util.Date;

@Immutable
@Loggable(value=1)
public final class SfComments
implements Comments {
    private final transient Comments origin;

    public SfComments(Comments cmt) {
        this.origin = cmt;
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public Issue issue() {
        return this.origin.issue();
    }

    @Override
    public Comment get(int number) {
        return new SfComment(this.origin.get(number));
    }

    @Override
    public Iterable<Comment> iterate(Date since) {
        return Iterables.transform(this.origin.iterate(since), input -> new SfComment((Comment)input));
    }

    @Override
    public Comment post(String text) throws IOException {
        Comment cmt;
        try {
            cmt = this.origin.post(text);
        }
        catch (AssertionError ex) {
            Logger.warn(this, "Failed to post to GitHub: %[exception]s", ex);
            cmt = new MkGithub().randomRepo().issues().create("", "").comments().post(text);
        }
        return cmt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SfComments)) {
            return false;
        }
        SfComments other = (SfComments)o;
        Comments this$origin = this.origin;
        Comments other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Comments $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

