/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.RequestBody;
import com.jcabi.immutable.Array;
import com.jcabi.log.Logger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Immutable
public interface MkAnswer {
    public int status();

    public Map<String, List<String>> headers();

    public String body();

    public byte[] bodyBytes();

    @Immutable
    @Loggable(value=1)
    public static final class Simple
    implements MkAnswer {
        private static final Charset CHARSET = Charset.forName("UTF-8");
        private final transient int code;
        private final transient Array<Map.Entry<String, String>> hdrs;
        @Immutable.Array
        private final transient byte[] content;

        public Simple(String body) {
            this(200, body);
        }

        public Simple(int status) {
            this(status, "");
        }

        public Simple(int status, String body) {
            this(status, new Array<Map.Entry<String, String>>(), body.getBytes(CHARSET));
        }

        public Simple(int status, Iterable<Map.Entry<String, String>> headers, byte[] body) {
            this.code = status;
            this.hdrs = new Array<Map.Entry<String, String>>(headers);
            this.content = (byte[])body.clone();
        }

        @Override
        public int status() {
            return this.code;
        }

        @Override
        public Map<String, List<String>> headers() {
            ConcurrentHashMap<String, List<String>> map = new ConcurrentHashMap<String, List<String>>(0);
            for (Map.Entry<String, String> header : this.hdrs) {
                map.putIfAbsent(header.getKey(), new LinkedList());
                ((List)map.get(header.getKey())).add(header.getValue());
            }
            return map;
        }

        @Override
        public String body() {
            return new String(this.content, CHARSET);
        }

        @Override
        public byte[] bodyBytes() {
            return (byte[])this.content.clone();
        }

        public String toString() {
            StringBuilder text = new StringBuilder(0).append(this.code).append('\n');
            for (Map.Entry<String, String> header : this.hdrs) {
                text.append(Logger.format("%s: %s\n", header.getKey(), header.getValue()));
            }
            return text.append('\n').append(new RequestBody.Printable(this.content)).toString();
        }

        public Simple withHeader(String name, String value) {
            return new Simple(this.code, this.hdrs.with(new ImmutableHeader(name, value)), this.content);
        }

        public Simple withStatus(int status) {
            return new Simple(status, this.hdrs, this.content);
        }

        public Simple withBody(String body) {
            return new Simple(this.code, this.hdrs, body.getBytes(CHARSET));
        }

        public Simple withBody(byte[] body) {
            return new Simple(this.code, this.hdrs, body);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple other = (Simple)o;
            if (this.code != other.code) {
                return false;
            }
            Array<Map.Entry<String, String>> this$hdrs = this.hdrs;
            Array<Map.Entry<String, String>> other$hdrs = other.hdrs;
            if (this$hdrs == null ? other$hdrs != null : !((Object)this$hdrs).equals(other$hdrs)) {
                return false;
            }
            return Arrays.equals(this.content, other.content);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.code;
            Array<Map.Entry<String, String>> $hdrs = this.hdrs;
            result = result * 59 + ($hdrs == null ? 43 : ((Object)$hdrs).hashCode());
            result = result * 59 + Arrays.hashCode(this.content);
            return result;
        }
    }
}

