/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.request;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.RequestBody;
import com.jcabi.http.RequestURI;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.http.request.BaseRequest;
import com.jcabi.http.request.DefaultResponse;
import com.jcabi.immutable.Array;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@Immutable
@Loggable(value=1)
public final class FakeRequest
implements Request {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final transient Request base;
    private final transient int code;
    private final transient String phrase;
    private final transient Array<Map.Entry<String, String>> hdrs;
    @Immutable.Array
    private final transient byte[] content;

    public FakeRequest() {
        this(200, "OK", Collections.emptyList(), EMPTY_BYTE_ARRAY);
    }

    public FakeRequest(int status, String reason, Collection<Map.Entry<String, String>> headers, byte[] body) {
        this.code = status;
        this.phrase = reason;
        this.hdrs = new Array<Map.Entry<String, String>>(headers);
        this.content = (byte[])body.clone();
        this.base = new BaseRequest(new Wire(){

            @Override
            public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream text, int connect, int read) {
                return new DefaultResponse(req, FakeRequest.this.code, FakeRequest.this.phrase, FakeRequest.this.hdrs, FakeRequest.this.content);
            }
        }, "http://localhost:12345/see-FakeRequest-class");
    }

    public String toString() {
        return this.base.toString();
    }

    @Override
    public RequestURI uri() {
        return this.base.uri();
    }

    @Override
    public Request header(String name, Object value) {
        return this.base.header(name, value);
    }

    @Override
    public Request reset(String name) {
        return this.base.reset(name);
    }

    @Override
    public RequestBody body() {
        return this.base.body();
    }

    @Override
    public RequestBody multipartBody() {
        return this.base.multipartBody();
    }

    @Override
    public Request method(String method) {
        return this.base.method(method);
    }

    @Override
    public Request timeout(int connect, int read) {
        return this.base.timeout(connect, read);
    }

    @Override
    public Response fetch() throws IOException {
        return this.base.fetch();
    }

    @Override
    public Response fetch(InputStream stream) throws IOException {
        if (this.content.length > 0) {
            throw new IllegalStateException("Request Body is not empty, use fetch() instead");
        }
        return this.base.fetch(stream);
    }

    @Override
    public <T extends Wire> Request through(Class<T> type, Object ... args) {
        return this.base.through(type, args);
    }

    @Override
    public Request through(Wire wire) {
        return this.base.through(wire);
    }

    public FakeRequest withStatus(int status) {
        return new FakeRequest(status, this.phrase, this.hdrs, this.content);
    }

    public FakeRequest withReason(String reason) {
        return new FakeRequest(this.code, reason, this.hdrs, this.content);
    }

    public FakeRequest withHeader(String name, String value) {
        return new FakeRequest(this.code, this.phrase, this.hdrs.with(new ImmutableHeader(name, value)), this.content);
    }

    public FakeRequest withBody(String text) {
        return this.withBody(text.getBytes(CHARSET));
    }

    public FakeRequest withBody(byte[] body) {
        return new FakeRequest(this.code, this.phrase, this.hdrs, body);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FakeRequest)) {
            return false;
        }
        FakeRequest other = (FakeRequest)o;
        if (this.code != other.code) {
            return false;
        }
        Request this$base = this.base;
        Request other$base = other.base;
        if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
            return false;
        }
        String this$phrase = this.phrase;
        String other$phrase = other.phrase;
        if (this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase)) {
            return false;
        }
        Array<Map.Entry<String, String>> this$hdrs = this.hdrs;
        Array<Map.Entry<String, String>> other$hdrs = other.hdrs;
        if (this$hdrs == null ? other$hdrs != null : !((Object)this$hdrs).equals(other$hdrs)) {
            return false;
        }
        return Arrays.equals(this.content, other.content);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        Request $base = this.base;
        result = result * 59 + ($base == null ? 43 : $base.hashCode());
        String $phrase = this.phrase;
        result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
        Array<Map.Entry<String, String>> $hdrs = this.hdrs;
        result = result * 59 + ($hdrs == null ? 43 : ((Object)$hdrs).hashCode());
        result = result * 59 + Arrays.hashCode(this.content);
        return result;
    }
}

