/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

@Immutable
public final class BasicAuthWire
implements Wire {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final transient Wire origin;

    public BasicAuthWire(Wire wire) {
        this.origin = wire;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        LinkedList<Map.Entry<String, String>> hdrs = new LinkedList<Map.Entry<String, String>>();
        boolean absent = true;
        for (Map.Entry<String, String> header : headers) {
            if (header.getKey().equals("Authorization")) {
                Logger.warn(this, "Request already contains %s header", "Authorization");
                absent = false;
            }
            hdrs.add(header);
        }
        String info = URI.create(home).getUserInfo();
        if (absent && info != null) {
            String[] parts = info.split(":", 2);
            hdrs.add(new ImmutableHeader("Authorization", Logger.format("Basic %s", DatatypeConverter.printBase64Binary(Logger.format("%s:%s", parts[0], parts[1]).getBytes(CHARSET)))));
        }
        return this.origin.send(req.uri().userInfo(null).back(), home, method, hdrs, content, connect, read);
    }

    public String toString() {
        return "BasicAuthWire(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicAuthWire)) {
            return false;
        }
        BasicAuthWire other = (BasicAuthWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

