/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.google.common.base.Joiner;
import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.http.request.DefaultResponse;
import com.jcabi.immutable.Array;
import com.jcabi.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import org.apache.commons.io.FileUtils;

@Immutable
final class FcCache {
    private static final String BODY = "body";
    private static final String STATUS = "status";
    private static final String REASON = "reason";
    private static final String HEADERS = "headers";
    private final transient String dir;

    FcCache() {
        this(new File(new File(System.getProperty("java.io.tmpdir")), String.format("%s-%d", FcCache.class.getCanonicalName(), System.nanoTime())).getAbsolutePath());
    }

    FcCache(String path) {
        this.dir = path;
    }

    public void invalidate() throws IOException {
        File file = this.file("").getParentFile();
        if (file.exists()) {
            FileUtils.deleteDirectory(file);
            Logger.debug(this, "cache invalidated in %s", file);
        }
    }

    public Response get(String label, Wire wire, Request request, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream input, int connect, int read) throws IOException {
        File file = this.file(label);
        Response rsp = file.exists() ? this.response(request, file) : this.saved(wire.send(request, home, method, headers, input, connect, read), file);
        return rsp;
    }

    private Response response(Request req, File file) throws IOException {
        JsonObject json = Json.createReader(new ByteArrayInputStream(FileUtils.readFileToByteArray(file))).readObject();
        LinkedList<AbstractMap.SimpleEntry<String, String>> map = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
        JsonObject headers = json.getJsonObject(HEADERS);
        for (String name : headers.keySet()) {
            for (JsonString value : headers.getJsonArray(name).getValuesAs(JsonString.class)) {
                map.add(new AbstractMap.SimpleEntry<String, String>(name, value.getString()));
            }
        }
        Logger.debug(this, "cache loaded from %s", file);
        return new DefaultResponse(req, json.getInt(STATUS), json.getString(REASON), new Array<Map.Entry<String, String>>((Collection<Map.Entry<String, String>>)map), json.getString(BODY).getBytes(StandardCharsets.UTF_8));
    }

    private Response saved(Response response, File file) throws IOException {
        JsonObjectBuilder json = Json.createObjectBuilder();
        json.add(STATUS, response.status());
        json.add(REASON, response.reason());
        JsonObjectBuilder headers = Json.createObjectBuilder();
        for (Map.Entry<String, List<String>> pair : response.headers().entrySet()) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            for (String value : pair.getValue()) {
                array.add(value);
            }
            headers.add(pair.getKey(), array);
        }
        json.add(HEADERS, headers);
        json.add(BODY, response.body());
        if (file.getParentFile().mkdirs()) {
            Logger.debug(this, "directory created for %s", file);
        }
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            Json.createWriter(out).write(json.build());
        }
        Logger.debug(this, "cache saved into %s", file);
        return response;
    }

    private File file(String label) {
        String path;
        try {
            path = Joiner.on("/").join(URLEncoder.encode(label, StandardCharsets.UTF_8.toString()).replaceAll("_", "__").replaceAll("\\+", "_").replaceAll("%", "_").split("(?<=\\G.{4})"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        return new File(this.dir, String.format("%s.json", path));
    }

    public String toString() {
        return "FcCache(dir=" + this.dir + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof FcCache;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

