/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

@Immutable
public final class TrustedWire
implements Wire {
    private static final TrustManager MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String type) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String types) {
        }
    };
    private final transient Wire origin;

    public TrustedWire(Wire wire) {
        this.origin = wire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        Class<TrustedWire> clazz = TrustedWire.class;
        synchronized (TrustedWire.class) {
            Response response;
            SSLSocketFactory def = HttpsURLConnection.getDefaultSSLSocketFactory();
            try {
                HttpsURLConnection.setDefaultSSLSocketFactory(TrustedWire.context().getSocketFactory());
                response = this.origin.send(req, home, method, headers, content, connect, read);
            }
            catch (Throwable throwable) {
                HttpsURLConnection.setDefaultSSLSocketFactory(def);
                throw throwable;
            }
            HttpsURLConnection.setDefaultSSLSocketFactory(def);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return response;
        }
    }

    private static SSLContext context() {
        try {
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, new TrustManager[]{MANAGER}, new SecureRandom());
            return ctx;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return "TrustedWire(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustedWire)) {
            return false;
        }
        TrustedWire other = (TrustedWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

