/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

final class ConsoleErrorListener
implements ErrorListener {
    private final Collection<String> errors = new CopyOnWriteArrayList<String>();

    ConsoleErrorListener() {
    }

    @Override
    public void warning(TransformerException warning) {
        Logger.warn(this, "#warning(): %s", warning.getMessageAndLocation());
        this.errors.add(warning.getMessageAndLocation());
    }

    @Override
    public void error(TransformerException error) throws TransformerException {
        Logger.error(this, "#error(): %s", error.getMessageAndLocation());
        this.errors.add(error.getMessageAndLocation());
        throw error;
    }

    @Override
    public void fatalError(TransformerException error) throws TransformerException {
        Logger.error(this, "#fatalError(): %s", error.getMessageAndLocation());
        this.errors.add(error.getMessageAndLocation());
        throw error;
    }

    public Collection<String> summary() {
        return Collections.unmodifiableCollection(this.errors);
    }
}

