/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapOf;

public final class XPathContext
implements NamespaceContext {
    private final transient Map<String, String> map;
    private final transient List<NamespaceContext> contexts;

    public XPathContext() {
        this(new MapOf<String, String>(new MapEntry<String, String>("xhtml", "http://www.w3.org/1999/xhtml"), new MapEntry<String, String>("xs", "http://www.w3.org/2001/XMLSchema"), new MapEntry<String, String>("xsi", "http://www.w3.org/2001/XMLSchema-instance"), new MapEntry<String, String>("xsl", "http://www.w3.org/1999/XSL/Transform"), new MapEntry<String, String>("svg", "http://www.w3.org/2000/svg")), new ArrayList<NamespaceContext>(0));
    }

    public XPathContext(Object ... namespaces) {
        this(XPathContext.namespacesAsMap(namespaces), new ArrayList<NamespaceContext>(0));
    }

    private XPathContext(Map<String, String> old, String prefix, Object namespace) {
        this(new MapOf<String, String>(old, new MapEntry<String, String>(prefix, namespace.toString())), new ArrayList<NamespaceContext>(0));
    }

    private XPathContext(Map<String, String> mapping, List<NamespaceContext> ctxs) {
        this.map = mapping;
        this.contexts = ctxs;
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String namespace = this.map.get(prefix);
        if (namespace == null) {
            NamespaceContext ctx;
            Iterator<NamespaceContext> iterator = this.contexts.iterator();
            while (iterator.hasNext() && (namespace = (ctx = iterator.next()).getNamespaceURI(prefix)) == null) {
            }
        }
        if (namespace == null) {
            namespace = prefix.equals("xml") ? "http://www.w3.org/XML/1998/namespace" : (prefix.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : "");
        }
        return namespace;
    }

    @Override
    public String getPrefix(String namespace) {
        Iterator<String> prefixes = this.getPrefixes(namespace);
        String prefix = null;
        if (prefixes.hasNext()) {
            prefix = prefixes.next();
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String namespace) {
        LinkedList<String> prefixes = new LinkedList<String>();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(namespace)) continue;
            prefixes.add(entry.getKey());
        }
        for (NamespaceContext ctx : this.contexts) {
            Iterator<String> iterator = ctx.getPrefixes(namespace);
            while (iterator.hasNext()) {
                prefixes.add(iterator.next().toString());
            }
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            prefixes.add("xml");
        }
        if (namespace.equals("http://www.w3.org/2000/xmlns/")) {
            prefixes.add("xmlns");
        }
        return Collections.unmodifiableList(prefixes).iterator();
    }

    public XPathContext add(String prefix, Object namespace) {
        if (this.map.containsKey(prefix)) {
            throw new IllegalArgumentException(String.format("Prefix '%s' already registered for namespace '%s'", prefix, this.map.get(prefix)));
        }
        return new XPathContext(this.map, prefix, namespace);
    }

    public XPathContext merge(NamespaceContext context) {
        ArrayList<NamespaceContext> list = new ArrayList<NamespaceContext>(this.contexts.size() + 1);
        list.addAll(this.contexts);
        list.add(context);
        return new XPathContext(this.map, list);
    }

    private static Map<String, String> namespacesAsMap(Object ... namespaces) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(namespaces.length);
        for (int pos = 0; pos < namespaces.length; ++pos) {
            map.put(Logger.format("ns%d", pos + 1), namespaces[pos].toString());
        }
        return new HashMap<String, String>(map);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XPathContext)) {
            return false;
        }
        XPathContext other = (XPathContext)o;
        Map<String, String> this$map = this.map;
        Map<String, String> other$map = other.map;
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        List<NamespaceContext> this$contexts = this.contexts;
        List<NamespaceContext> other$contexts = other.contexts;
        return !(this$contexts == null ? other$contexts != null : !((Object)this$contexts).equals(other$contexts));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        List<NamespaceContext> $contexts = this.contexts;
        result = result * 59 + ($contexts == null ? 43 : ((Object)$contexts).hashCode());
        return result;
    }
}

