/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import com.jcabi.xml.ConsoleErrorListener;
import com.jcabi.xml.Sources;
import com.jcabi.xml.TextResource;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XSL;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.jaxp.TransformerImpl;
import net.sf.saxon.serialize.MessageWarner;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapOf;
import org.w3c.dom.Document;

public final class XSLDocument
implements XSL {
    public static final XSL STRIP = XSLDocument.make(XSL.class.getResourceAsStream("strip.xsl"));
    private static final DocumentBuilderFactory DFACTORY = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory TFACTORY = TransformerFactory.newInstance();
    private final transient String xsl;
    private final transient Sources sources;
    private final transient Map<String, Object> params;
    private final transient String sid;
    private final transient AtomicReference<Transformer> cached = new AtomicReference();

    public XSLDocument(XML src) {
        this(src, "/");
    }

    public XSLDocument(XML src, String base) {
        this(src.toString(), base);
    }

    public XSLDocument(URL url) throws IOException {
        this(url, url.toString());
    }

    public XSLDocument(URL url, String base) throws IOException {
        this(new TextResource(url).toString(), base);
    }

    public XSLDocument(File file) throws FileNotFoundException {
        this(file, file.getAbsolutePath());
    }

    public XSLDocument(File file, String base) throws FileNotFoundException {
        this(new TextResource(file).toString(), base);
    }

    public XSLDocument(Path file) throws FileNotFoundException {
        this(file.toFile());
    }

    public XSLDocument(Path file, String base) throws FileNotFoundException {
        this(file.toFile(), base);
    }

    public XSLDocument(URI uri) throws IOException {
        this(uri, uri.toString());
    }

    public XSLDocument(URI uri, String base) throws IOException {
        this(new TextResource(uri).toString(), base);
    }

    public XSLDocument(InputStream stream) {
        this(new TextResource(stream).toString());
    }

    public XSLDocument(InputStream stream, String base) {
        this(new TextResource(stream).toString(), base);
    }

    public XSLDocument(String src) {
        this(src, Sources.DUMMY);
    }

    public XSLDocument(String src, String base) {
        this(src, Sources.DUMMY, base);
    }

    public XSLDocument(String src, Sources srcs) {
        this(src, srcs, new HashMap<String, Object>(0));
    }

    public XSLDocument(String src, Sources srcs, String base) {
        this(src, srcs, new HashMap<String, Object>(0), base);
    }

    public XSLDocument(String src, Sources srcs, Map<String, Object> map) {
        this(src, srcs, map, "/");
    }

    public XSLDocument(String src, Sources srcs, Map<String, Object> map, String base) {
        this.xsl = src;
        this.sources = srcs;
        this.params = new HashMap<String, Object>(map);
        this.sid = base;
    }

    @Override
    public XSL with(Sources src) {
        return new XSLDocument(this.xsl, src, this.params, this.sid);
    }

    @Override
    public XSL with(String name, Object value) {
        return new XSLDocument(this.xsl, this.sources, new MapOf<String, Object>(this.params, new MapEntry<String, Object>(name, value)), this.sid);
    }

    public static XSL make(InputStream stream) {
        return new XSLDocument(stream);
    }

    public static XSL make(URL url) {
        try {
            return new XSLDocument(url, url.toString());
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Failed to read from URL '%s'", url), ex);
        }
    }

    public String toString() {
        return new XMLDocument(this.xsl).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XML transform(XML xml) {
        DocumentBuilder builder;
        try {
            DocumentBuilderFactory documentBuilderFactory = DFACTORY;
            synchronized (documentBuilderFactory) {
                builder = DFACTORY.newDocumentBuilder();
            }
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalArgumentException(String.format("Failed to create new XML document by %s", DFACTORY.getClass().getName()), ex);
        }
        Document target = builder.newDocument();
        this.transformInto(xml, new DOMResult(target));
        return new XMLDocument(target);
    }

    @Override
    public String applyTo(XML xml) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transformInto(xml, new StreamResult(baos));
        try {
            return baos.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Failed to convert bytes into UTF-8 string", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformInto(XML xml, Result result) {
        Transformer trans = this.transformer();
        ConsoleErrorListener errors = new ConsoleErrorListener();
        trans.setErrorListener(errors);
        long start = System.nanoTime();
        try {
            DocumentBuilderFactory documentBuilderFactory = DFACTORY;
            synchronized (documentBuilderFactory) {
                trans.transform(new DOMSource(xml.node()), result);
            }
        }
        catch (TransformerException ex) {
            StringBuilder summary = new StringBuilder(String.join((CharSequence)"; ", errors.summary()));
            if (!summary.toString().equals(ex.getMessageAndLocation())) {
                summary.append("; ").append(ex.getMessageAndLocation());
            }
            throw new IllegalArgumentException(String.format("Failed to transform by %s: %s", trans.getClass().getName(), summary), ex);
        }
        if (Logger.isTraceEnabled(this)) {
            Logger.trace(this, "%s transformed XML in %[nano]s", trans.getClass().getName(), System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer transformer() {
        TransformerFactory transformerFactory = TFACTORY;
        synchronized (transformerFactory) {
            if (this.cached.get() == null) {
                Transformer trans;
                TFACTORY.setURIResolver(this.sources);
                try {
                    trans = TFACTORY.newTransformer(new StreamSource(new StringReader(this.xsl), this.sid));
                }
                catch (TransformerConfigurationException ex) {
                    throw new IllegalArgumentException(String.format("Failed to create transformer by %s", TFACTORY.getClass().getName()), ex);
                }
                for (Map.Entry<String, Object> ent : this.params.entrySet()) {
                    trans.setParameter(ent.getKey(), ent.getValue());
                }
                this.cached.set(XSLDocument.forSaxon(trans));
            }
        }
        return this.cached.get();
    }

    private static Transformer forSaxon(Transformer trans) {
        String type = trans.getClass().getCanonicalName();
        if (!"net.sf.saxon.jaxp.TransformerImpl".equals(type)) {
            return trans;
        }
        if (Version.getStructuredVersionNumber()[0] < 11) {
            ((TransformerImpl)trans).getUnderlyingController().setMessageEmitter((Receiver)new MessageWarner());
        }
        if (Version.getStructuredVersionNumber()[0] >= 11) {
            ((TransformerImpl)trans).getUnderlyingController().setMessageHandler(message -> Logger.error(XSLDocument.class, "%s: %s", message.getLocation(), message.toString()));
        }
        return trans;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XSLDocument)) {
            return false;
        }
        XSLDocument other = (XSLDocument)o;
        String this$xsl = this.xsl;
        String other$xsl = other.xsl;
        return !(this$xsl == null ? other$xsl != null : !this$xsl.equals(other$xsl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xsl = this.xsl;
        result = result * 59 + ($xsl == null ? 43 : $xsl.hashCode());
        return result;
    }
}

