/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.bytes;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import org.cactoos.Bytes;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.bytes.InputAsBytes;
import org.cactoos.bytes.ReaderAsBytes;
import org.cactoos.io.InputOf;
import org.cactoos.iterable.IterableOf;
import org.cactoos.list.ListOf;

public final class BytesOf
implements Bytes {
    private final Bytes origin;

    public BytesOf(Input input) {
        this(new InputAsBytes(input));
    }

    public BytesOf(InputStream input) {
        this(new InputAsBytes(new InputOf(input)));
    }

    public BytesOf(File file) {
        this(new InputOf(file));
    }

    public BytesOf(Path path) {
        this(new InputOf(path));
    }

    public BytesOf(Input input, int max) {
        this(new InputAsBytes(input, max));
    }

    public BytesOf(Reader rdr) {
        this(new ReaderAsBytes(rdr));
    }

    public BytesOf(Reader rdr, Charset charset) {
        this(new ReaderAsBytes(rdr, charset));
    }

    public BytesOf(Reader rdr, CharSequence charset) {
        this(new ReaderAsBytes(rdr, charset));
    }

    public BytesOf(Reader rdr, Charset charset, int max) {
        this(new ReaderAsBytes(rdr, charset, max));
    }

    public BytesOf(Reader rdr, int max) {
        this(new ReaderAsBytes(rdr, max));
    }

    public BytesOf(Reader rdr, CharSequence charset, int max) {
        this(new ReaderAsBytes(rdr, charset, max));
    }

    public BytesOf(CharSequence input) {
        this(input, StandardCharsets.UTF_8);
    }

    public BytesOf(CharSequence input, Charset charset) {
        this(() -> input.toString().getBytes(charset));
    }

    public BytesOf(CharSequence input, CharSequence charset) {
        this(() -> input.toString().getBytes(charset.toString()));
    }

    public BytesOf(char ... chars) {
        this(chars, StandardCharsets.UTF_8);
    }

    public BytesOf(char[] chars, Charset charset) {
        this((CharSequence)new String(chars), charset);
    }

    public BytesOf(char[] chars, CharSequence charset) {
        this((CharSequence)new String(chars), charset);
    }

    public BytesOf(Text text) {
        this(text, StandardCharsets.UTF_8);
    }

    public BytesOf(Text text, Charset charset) {
        this(() -> text.asString().getBytes(charset));
    }

    public BytesOf(Text text, CharSequence charset) {
        this(() -> text.asString().getBytes(charset.toString()));
    }

    public BytesOf(Throwable error) {
        this(error, StandardCharsets.UTF_8);
    }

    public BytesOf(Throwable error, Charset charset) {
        this(error, (CharSequence)charset.name());
    }

    public BytesOf(Throwable error, CharSequence charset) {
        this(() -> {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                error.printStackTrace(new PrintStream((OutputStream)baos, true, charset.toString()));
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        });
    }

    public BytesOf(StackTraceElement ... strace) {
        this(strace, StandardCharsets.UTF_8);
    }

    public BytesOf(StackTraceElement[] strace, Charset charset) {
        this(strace, (CharSequence)charset.name());
    }

    public BytesOf(StackTraceElement[] strace, CharSequence charset) {
        this(() -> {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                PrintStream stream = new PrintStream((OutputStream)baos, true, charset.toString());
                try {
                    for (StackTraceElement element : strace) {
                        stream.append(element.toString());
                        stream.append("\n");
                    }
                    byte[] throwable = baos.toByteArray();
                    stream.close();
                    return throwable;
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
    }

    public BytesOf(byte ... bytes) {
        this(() -> bytes);
    }

    public BytesOf(Iterator<Byte> iterator) {
        this(new IterableOf<Byte>(iterator));
    }

    public BytesOf(Iterable<Byte> bytes) {
        this(() -> {
            ListOf<Byte> concrete = new ListOf<Byte>(bytes);
            ByteBuffer buf = ByteBuffer.allocate(concrete.size());
            concrete.forEach(buf::put);
            return buf.array();
        });
    }

    public BytesOf(Collection<Byte> bytes) {
        this(() -> {
            ByteBuffer buf = ByteBuffer.allocate(bytes.size());
            bytes.forEach(buf::put);
            return buf.array();
        });
    }

    private BytesOf(Bytes bytes) {
        this.origin = bytes;
    }

    @Override
    public byte[] asBytes() throws Exception {
        return this.origin.asBytes();
    }
}

