/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.cactoos.Bytes;
import org.cactoos.Input;

public abstract class DigestEnvelope
implements Bytes {
    private final Input source;
    private final int size;
    private final String algorithm;

    public DigestEnvelope(Input input, String algrthm) {
        this(input, 16384, algrthm);
    }

    public DigestEnvelope(Input input, int max, String algrthm) {
        this.source = input;
        this.size = max;
        this.algorithm = algrthm;
    }

    @Override
    public byte[] asBytes() throws Exception {
        byte[] byArray;
        block9: {
            InputStream stream = this.source.stream();
            try {
                int len;
                MessageDigest msg = MessageDigest.getInstance(this.algorithm);
                byte[] buf = new byte[this.size];
                while ((len = stream.read(buf)) >= 0) {
                    msg.update(buf, 0, len);
                }
                byArray = msg.digest();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new IOException(ex);
                }
            }
            stream.close();
        }
        return byArray;
    }
}

