/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.bytes;

import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.cactoos.Bytes;

final class ReaderAsBytes
implements Bytes {
    private final Reader reader;
    private final CharSequence charset;
    private final int size;

    ReaderAsBytes(Reader rdr) {
        this(rdr, StandardCharsets.UTF_8);
    }

    ReaderAsBytes(Reader rdr, Charset cset) {
        this(rdr, cset, 16384);
    }

    ReaderAsBytes(Reader rdr, CharSequence cset) {
        this(rdr, cset, 16384);
    }

    ReaderAsBytes(Reader rdr, Charset cset, int max) {
        this(rdr, cset.name(), max);
    }

    ReaderAsBytes(Reader rdr, int max) {
        this(rdr, StandardCharsets.UTF_8, max);
    }

    ReaderAsBytes(Reader rdr, CharSequence cset, int max) {
        this.reader = rdr;
        this.charset = cset;
        this.size = max;
    }

    @Override
    public byte[] asBytes() throws Exception {
        int done;
        char[] buffer = new char[this.size];
        StringBuilder builder = new StringBuilder(this.size);
        while ((done = this.reader.read(buffer, 0, buffer.length)) >= 0) {
            builder.append(buffer, 0, done);
        }
        this.reader.close();
        return builder.toString().getBytes(this.charset.toString());
    }
}

