/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.experimental;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cactoos.Func;
import org.cactoos.Scalar;
import org.cactoos.func.UncheckedFunc;
import org.cactoos.iterable.IterableEnvelope;
import org.cactoos.iterable.IterableOf;
import org.cactoos.iterable.Mapped;
import org.cactoos.list.ListOf;
import org.cactoos.scalar.CallableOf;

public final class Threads<T>
extends IterableEnvelope<T> {
    @SafeVarargs
    public Threads(ExecutorService exc, Scalar<? extends T> ... tasks) {
        this(exc, new IterableOf<Scalar<? extends T>>(tasks));
    }

    public Threads(ExecutorService exc, Iterable<? extends Scalar<? extends T>> tasks) {
        this((Iterable<Callable<T>> input) -> exc.invokeAll(new ListOf(input)), tasks);
    }

    @SafeVarargs
    public Threads(int threads, Scalar<? extends T> ... tasks) {
        this(threads, new IterableOf<Scalar<? extends T>>(tasks));
    }

    public Threads(int threads, Iterable<? extends Scalar<? extends T>> tasks) {
        this((Iterable<Callable<T>> todo) -> {
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            try {
                List list = executor.invokeAll(new ListOf(todo));
                return list;
            }
            finally {
                executor.shutdown();
            }
        }, tasks);
    }

    @SafeVarargs
    public Threads(ExecutorService exc, Duration timeout, Scalar<? extends T> ... tasks) {
        this(exc, timeout, new IterableOf<Scalar<? extends T>>(tasks));
    }

    public Threads(ExecutorService exc, Duration timeout, Iterable<? extends Scalar<? extends T>> tasks) {
        this((Iterable<Callable<T>> input) -> exc.invokeAll(new ListOf(input), timeout.toNanos(), TimeUnit.NANOSECONDS), tasks);
    }

    @SafeVarargs
    public Threads(int threads, Duration timeout, Scalar<? extends T> ... tasks) {
        this(threads, timeout, new IterableOf<Scalar<? extends T>>(tasks));
    }

    public Threads(int threads, Duration timeout, Iterable<? extends Scalar<? extends T>> tasks) {
        this((Iterable<Callable<T>> todo) -> {
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            try {
                List list = executor.invokeAll(new ListOf(todo), timeout.toNanos(), TimeUnit.NANOSECONDS);
                return list;
            }
            finally {
                executor.shutdown();
            }
        }, tasks);
    }

    private Threads(Func<Iterable<Callable<T>>, Iterable<Future<T>>> fnc, Iterable<? extends Scalar<? extends T>> tasks) {
        super(() -> new Mapped<Object>(Future::get, (Iterable)new UncheckedFunc(fnc).apply(new Mapped<Callable>(CallableOf::new, tasks))).iterator());
    }
}

