/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.func;

import org.cactoos.Func;

public final class Repeated<X, Y>
implements Func<X, Y> {
    private final Func<? super X, ? extends Y> func;
    private final int times;

    public Repeated(Func<? super X, ? extends Y> fnc, int max) {
        this.func = fnc;
        this.times = max;
    }

    @Override
    public Y apply(X input) throws Exception {
        if (this.times <= 0) {
            throw new IllegalArgumentException("The number of repetitions must be at least 1");
        }
        Y result = null;
        for (int idx = 0; idx < this.times; ++idx) {
            result = this.func.apply(input);
        }
        return result;
    }
}

