/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.func;

import java.time.Duration;
import org.cactoos.Func;

public final class Retry<X, Y>
implements Func<X, Y> {
    private final Func<X, Y> func;
    private final Func<Integer, Boolean> exit;
    private final Duration wait;

    public Retry(Func<X, Y> fnc) {
        this(fnc, 3);
    }

    public Retry(Func<X, Y> fnc, int attempts) {
        this(fnc, attempts, Duration.ZERO);
    }

    public Retry(Func<X, Y> fnc, int attempts, Duration wait) {
        this(fnc, attempt -> attempt >= attempts, wait);
    }

    public Retry(Func<X, Y> fnc, Func<Integer, Boolean> ext) {
        this(fnc, ext, Duration.ZERO);
    }

    public Retry(Func<X, Y> fnc, Func<Integer, Boolean> ext, Duration wait) {
        this.func = fnc;
        this.exit = ext;
        this.wait = wait;
    }

    @Override
    public Y apply(X input) throws Exception {
        int attempt = 0;
        Exception error = new IllegalArgumentException("An immediate exit, didn't have a chance to try at least once");
        while (!this.exit.apply(attempt).booleanValue()) {
            try {
                return this.func.apply(input);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                error = ex;
                break;
            }
            catch (Exception ex) {
                error = ex;
                if (!this.wait.isZero() && !this.wait.isNegative()) {
                    try {
                        Thread.sleep(this.wait.toMillis());
                    }
                    catch (InterruptedException ex2) {
                        error = ex2;
                        break;
                    }
                }
                ++attempt;
            }
        }
        throw error;
    }
}

