/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.InputStream;

public final class HeadInputStream
extends InputStream {
    private final InputStream origin;
    private final long length;
    private long processed;

    public HeadInputStream(InputStream orig, int len) {
        this.origin = orig;
        this.length = len;
    }

    @Override
    public int read() throws IOException {
        int adjusted;
        if (this.processed >= this.length) {
            adjusted = -1;
        } else {
            ++this.processed;
            adjusted = this.origin.read();
        }
        return adjusted;
    }

    @Override
    public long skip(long skip) throws IOException {
        long adjusted = this.processed + skip > this.length ? this.length - this.processed : skip;
        long skipped = this.origin.skip(adjusted);
        this.processed += skipped;
        return skipped;
    }

    @Override
    public void reset() throws IOException {
        this.processed = 0L;
        this.origin.reset();
    }

    @Override
    public int available() throws IOException {
        int available = this.origin.available();
        int adjusted = this.processed + (long)available > this.length ? (int)(this.length - this.processed) : available;
        return adjusted;
    }

    @Override
    public void close() throws IOException {
        this.origin.close();
    }

    @Override
    public boolean markSupported() {
        return this.origin.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.origin.mark(readlimit);
    }
}

