/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Path;
import org.cactoos.Output;
import org.cactoos.io.WriterAsOutputStream;

public final class OutputTo
implements Output {
    private final Output origin;

    public OutputTo(File file) {
        this(file, true);
    }

    public OutputTo(File file, boolean mkdirs) {
        this(() -> {
            if (mkdirs) {
                file.getAbsoluteFile().getParentFile().mkdirs();
            }
            return new FileOutputStream(file);
        });
    }

    public OutputTo(Path path) {
        this(path, true);
    }

    public OutputTo(Path path, boolean mkdirs) {
        this(() -> {
            File file = path.toFile();
            if (mkdirs) {
                file.getParentFile().mkdirs();
            }
            return new FileOutputStream(file);
        });
    }

    public OutputTo(Writer writer) {
        this(new WriterAsOutputStream(writer));
    }

    OutputTo(Writer wtr, Charset charset) {
        this(new WriterAsOutputStream(wtr, charset));
    }

    OutputTo(Writer wtr, CharSequence charset) {
        this(new WriterAsOutputStream(wtr, charset));
    }

    OutputTo(Writer wtr, Charset charset, int size) {
        this(new WriterAsOutputStream(wtr, charset, size));
    }

    OutputTo(Writer wtr, int size) {
        this(new WriterAsOutputStream(wtr, size));
    }

    OutputTo(Writer wtr, CharSequence charset, int size) {
        this(new WriterAsOutputStream(wtr, charset, size));
    }

    OutputTo(Writer wtr, CharsetDecoder ddr, int size) {
        this(new WriterAsOutputStream(wtr, ddr, size));
    }

    public OutputTo(OutputStream stream) {
        this(() -> stream);
    }

    private OutputTo(Output output) {
        this.origin = output;
    }

    @Override
    public OutputStream stream() throws Exception {
        return this.origin.stream();
    }
}

