/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.InputStream;
import org.cactoos.Func;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.bytes.BytesOf;
import org.cactoos.func.IoCheckedFunc;
import org.cactoos.io.InputOf;
import org.cactoos.text.FormattedText;
import org.cactoos.text.TextOf;

public final class ResourceOf
implements Input {
    private final Text path;
    private final Func<Text, Input> fallback;
    private final ClassLoader loader;

    public ResourceOf(CharSequence res) {
        this(res, Thread.currentThread().getContextClassLoader());
    }

    public ResourceOf(CharSequence res, Class<?> cls) {
        this(res, cls.getClassLoader());
    }

    public ResourceOf(CharSequence res, ClassLoader ldr) {
        this((Text)new TextOf(res), ldr);
    }

    public ResourceOf(CharSequence res, Func<CharSequence, Input> fbk, Class<?> cls) {
        this(res, fbk, cls.getClassLoader());
    }

    public ResourceOf(CharSequence res, Func<CharSequence, Input> fbk, ClassLoader ldr) {
        this(new TextOf(res), (Text input) -> (Input)fbk.apply(input.asString()), ldr);
    }

    public ResourceOf(CharSequence res, CharSequence fbk) {
        this(res, (CharSequence input) -> new InputOf(new BytesOf(fbk)));
    }

    public ResourceOf(CharSequence res, Func<CharSequence, Input> fbk) {
        this(res, fbk, Thread.currentThread().getContextClassLoader());
    }

    public ResourceOf(CharSequence res, Input fbk) {
        this(res, (CharSequence input) -> fbk);
    }

    public ResourceOf(Text res) {
        this(res, Thread.currentThread().getContextClassLoader());
    }

    public ResourceOf(Text res, ClassLoader ldr) {
        this(res, (Text input) -> {
            throw new IOException(new FormattedText("The resource \"%s\" was not found in %s", input, ldr).asString());
        }, ldr);
    }

    public ResourceOf(Text res, Text fbk) {
        this(res, (Text input) -> new InputOf(fbk));
    }

    public ResourceOf(Text res, Input fbk) {
        this(res, (Text input) -> fbk);
    }

    public ResourceOf(Text res, Func<Text, Input> fbk) {
        this(res, fbk, Thread.currentThread().getContextClassLoader());
    }

    public ResourceOf(Text res, Func<Text, Input> fbk, ClassLoader ldr) {
        this.path = res;
        this.loader = ldr;
        this.fallback = fbk;
    }

    @Override
    public InputStream stream() throws Exception {
        InputStream input = this.loader.getResourceAsStream(this.path.asString());
        if (input == null) {
            input = new IoCheckedFunc<Text, Input>(this.fallback).apply(this.path).stream();
        }
        return input;
    }
}

