/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.cactoos.Input;
import org.cactoos.number.MinOf;
import org.cactoos.text.FormattedText;

public final class TailOf
implements Input {
    private final Input input;
    private final int count;
    private final int max;

    public TailOf(Input inpt, int bytes) {
        this(inpt, bytes, 16384);
    }

    public TailOf(Input inpt, int bytes, int maximum) {
        this.input = inpt;
        this.count = bytes;
        this.max = maximum;
    }

    @Override
    public InputStream stream() throws Exception {
        if (this.max < this.count) {
            throw new IllegalArgumentException(new FormattedText("Can't tail %d bytes if buffer is set to %d", this.count, this.max).asString());
        }
        byte[] buffer = new byte[this.max];
        byte[] response = new byte[this.count];
        int num = 0;
        InputStream strm = this.input.stream();
        int read = strm.read(buffer);
        while (read > 0) {
            num = read < this.max && read < this.count ? this.copyPartial(buffer, response, num, read) : this.copy(buffer, response, read);
            read = strm.read(buffer);
        }
        return new ByteArrayInputStream(response, 0, num);
    }

    private int copy(byte[] buffer, byte[] response, int read) {
        System.arraycopy(buffer, read - this.count, response, 0, this.count);
        return new MinOf(this.count, read).intValue();
    }

    private int copyPartial(byte[] buffer, byte[] response, int num, int read) {
        int result;
        if (num > 0) {
            System.arraycopy(response, read, response, 0, this.count - read);
            System.arraycopy(buffer, 0, response, this.count - read, read);
            result = this.count;
        } else {
            System.arraycopy(buffer, 0, response, 0, read);
            result = read;
        }
        return result;
    }
}

