/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.cactoos.io.Directory;
import org.cactoos.iterable.IterableOf;
import org.cactoos.iterable.Joined;
import org.cactoos.iterable.RangeOf;
import org.cactoos.iterable.Sorted;
import org.cactoos.proc.ForEach;
import org.cactoos.proc.IoCheckedProc;
import org.cactoos.scalar.IoChecked;
import org.cactoos.scalar.Sticky;
import org.cactoos.text.Concatenated;
import org.cactoos.text.Randomized;
import org.cactoos.text.TextOf;

public final class TempFolder
implements Scalar<Path>,
Closeable {
    private final Scalar<Path> folder;

    public TempFolder() {
        this(new Concatenated(new TextOf("tmp"), new Randomized(new Joined<Character>((Iterable<Iterable<Character>>)new IterableOf<RangeOf>(new RangeOf<Character>(Character.valueOf('0'), Character.valueOf('9'), ch -> {
            ch = Character.valueOf((char)(ch.charValue() + '\u0001'));
            return ch;
        }), new RangeOf<Character>(Character.valueOf('A'), Character.valueOf('Z'), ch -> {
            ch = Character.valueOf((char)(ch.charValue() + '\u0001'));
            return ch;
        }), new RangeOf<Character>(Character.valueOf('a'), Character.valueOf('z'), ch -> {
            ch = Character.valueOf((char)(ch.charValue() + '\u0001'));
            return ch;
        }))), () -> 5)));
    }

    public TempFolder(String path) {
        this(new TextOf(path));
    }

    public TempFolder(Text path) {
        this(new Sticky<Path>(() -> Files.createDirectory(Paths.get(new org.cactoos.text.Joined((CharSequence)File.separator, System.getProperty("java.io.tmpdir"), path.asString()).asString(), new String[0]), new FileAttribute[0])));
    }

    private TempFolder(Scalar<Path> flr) {
        this.folder = flr;
    }

    @Override
    public Path value() throws Exception {
        return this.folder.value();
    }

    @Override
    public void close() throws IOException {
        new IoCheckedProc<Path>(new ForEach<Path>(path -> path.toFile().delete())).exec((Path)((Object)new Sorted<Path>((Comparator<Path>)Comparator.reverseOrder(), new Directory(new IoChecked<Path>(this).value()))));
    }
}

