/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.cactoos.Output;
import org.cactoos.Scalar;
import org.cactoos.io.OutputTo;
import org.cactoos.scalar.Sticky;
import org.cactoos.scalar.Unchecked;

public final class WriterTo
extends Writer {
    private final Unchecked<Writer> target;

    public WriterTo(Path path) {
        this(new OutputTo(path));
    }

    public WriterTo(File file) {
        this(new OutputTo(file));
    }

    public WriterTo(OutputStream stream) {
        this(new OutputTo(stream));
    }

    public WriterTo(Output output) {
        this(output, StandardCharsets.UTF_8);
    }

    public WriterTo(Output output, Charset charset) {
        this(() -> new OutputStreamWriter(output.stream(), charset));
    }

    public WriterTo(Output output, CharSequence charset) {
        this(() -> new OutputStreamWriter(output.stream(), charset.toString()));
    }

    public WriterTo(Output output, CharsetEncoder encoder) {
        this(() -> new OutputStreamWriter(output.stream(), encoder));
    }

    private WriterTo(Scalar<Writer> tgt) {
        this.target = new Unchecked<Writer>(new Sticky<Writer>(tgt));
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.target.value().write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.target.value().flush();
    }

    @Override
    public void close() throws IOException {
        this.target.value().close();
    }
}

