/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public final class Cycled<T>
implements Iterator<T> {
    private final Iterable<? extends T> origin;
    private final AtomicReference<Iterator<? extends T>> reference;

    public Cycled(Iterable<? extends T> iterable) {
        this.origin = iterable;
        this.reference = new AtomicReference<Iterator<T>>(iterable.iterator());
    }

    @Override
    public boolean hasNext() {
        if (!this.reference.get().hasNext()) {
            this.reference.compareAndSet(this.reference.get(), this.origin.iterator());
        }
        return this.reference.get().hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have any more items");
        }
        return this.reference.get().next();
    }
}

