/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cactoos.Scalar;
import org.cactoos.scalar.Unchecked;

public final class Endless<T>
implements Iterator<T> {
    private final Unchecked<? extends T> origin;

    public Endless(T element) {
        this(() -> element);
    }

    public Endless(Scalar<? extends T> scalar) {
        this(new Unchecked<T>(scalar));
    }

    private Endless(Unchecked<? extends T> scalar) {
        this.origin = scalar;
    }

    @Override
    public boolean hasNext() {
        return this.origin.value() != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have item");
        }
        return this.origin.value();
    }
}

