/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cactoos.Bytes;
import org.cactoos.Text;
import org.cactoos.bytes.BytesOf;
import org.cactoos.bytes.UncheckedBytes;

public final class IteratorOfBytes
implements Iterator<Byte> {
    private final byte[] items;
    private final AtomicInteger position;

    public IteratorOfBytes(Text txt) {
        this(new BytesOf(txt));
    }

    public IteratorOfBytes(String str) {
        this(new BytesOf(str));
    }

    public IteratorOfBytes(Bytes bytes) {
        this(new UncheckedBytes(bytes).asBytes());
    }

    public IteratorOfBytes(byte ... itms) {
        this.items = itms;
        this.position = new AtomicInteger(0);
    }

    @Override
    public boolean hasNext() {
        return this.position.intValue() < this.items.length;
    }

    @Override
    public Byte next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have any more items");
        }
        return this.items[this.position.getAndIncrement()];
    }
}

