/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cactoos.Text;

public final class IteratorOfChars
implements Iterator<Character> {
    private final char[] list;
    private final AtomicInteger position;

    public IteratorOfChars(String str) {
        this(str.toCharArray());
    }

    public IteratorOfChars(Text txt) {
        this(txt.toString());
    }

    public IteratorOfChars(char ... items) {
        this.list = items;
        this.position = new AtomicInteger(0);
    }

    @Override
    public boolean hasNext() {
        return this.position.intValue() < this.list.length;
    }

    @Override
    public Character next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have any more items");
        }
        return Character.valueOf(this.list[this.position.getAndIncrement()]);
    }
}

