/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.cactoos.Func;
import org.cactoos.func.UncheckedFunc;

public final class Paged<X>
implements Iterator<X> {
    private final AtomicReference<Iterator<? extends X>> current;
    private final Func<? super Iterator<? extends X>, ? extends Iterator<? extends X>> subsequent;

    public Paged(Iterator<? extends X> first, Func<? super Iterator<? extends X>, ? extends Iterator<? extends X>> next) {
        this.current = new AtomicReference<Iterator<X>>(first);
        this.subsequent = next;
    }

    @Override
    public boolean hasNext() {
        if (!this.current.get().hasNext()) {
            Iterator<? extends X> next = new UncheckedFunc<Iterator<Iterator<? extends X>>, Iterator<Iterator<? extends X>>>(this.subsequent).apply(this.current.get());
            this.current.set(next);
        }
        return this.current.get().hasNext();
    }

    @Override
    public X next() {
        if (this.hasNext()) {
            return this.current.get().next();
        }
        throw new NoSuchElementException();
    }
}

