/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.cactoos.iterator.Sliced;
import org.cactoos.list.Immutable;
import org.cactoos.list.ListOf;

public final class Partitioned<T>
implements Iterator<List<T>> {
    private final Iterator<? extends T> decorated;
    private final int size;

    public Partitioned(int sze, Iterator<? extends T> src) {
        this.size = sze;
        this.decorated = src;
    }

    @Override
    public boolean hasNext() {
        return this.decorated.hasNext();
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No partition left.");
        }
        if (this.size < 1) {
            throw new IllegalArgumentException("Partition size < 1");
        }
        return new Immutable<T>(new ListOf<T>(new Sliced<T>(0, this.size, this.decorated)));
    }
}

