/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.cactoos.Func;
import org.cactoos.func.UncheckedFunc;

public final class RangeOf<T extends Comparable<T>>
implements Iterator<T> {
    private final UncheckedFunc<? super T, ? extends T> inc;
    private final AtomicReference<T> value;
    private final T max;

    public RangeOf(T min2, T max, Func<? super T, ? extends T> incrementor) {
        this.inc = new UncheckedFunc<T, T>(incrementor);
        this.value = new AtomicReference<T>(min2);
        this.max = max;
    }

    @Override
    public boolean hasNext() {
        return ((Comparable)this.value.get()).compareTo(this.max) < 1;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Comparable result = (Comparable)this.value.get();
        this.value.set((Comparable)this.inc.apply(result));
        return (T)result;
    }
}

