/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cactoos.Scalar;
import org.cactoos.scalar.Unchecked;

public final class Repeated<T>
implements Iterator<T> {
    private final Unchecked<? extends T> elm;
    private int repeat;

    public Repeated(int max, T element) {
        this(max, () -> element);
    }

    public Repeated(int max, Scalar<? extends T> scalar) {
        this.repeat = max;
        this.elm = new Unchecked<T>(scalar);
    }

    @Override
    public boolean hasNext() {
        return this.repeat > 0;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator can't repeat anymore.");
        }
        --this.repeat;
        return this.elm.value();
    }
}

